/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2022 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#pragma once

#include "headas.h"
#include <iostream>

// This header defines the macro healog, which uses headas_chatpar in a
// similar way to headas_chat, but yields an ostream - meaning it can be used
// in a more "C++" way

// An example use would be
// healog(4) << "A Warning!" << std::endl;

// general procedure inspired by
// https://stackoverflow.com/a/1255653

class nullstreambuf: public std::streambuf
{
};

static nullstreambuf nostreambuf;
static std::ostream nocout(&nostreambuf);

#define healog(x) ((x <= headas_chatpar)? std::cout : nocout)
