/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2023 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#pragma once

#include "SixteCCFits.h"
#include <string>

namespace sixte {

std::unique_ptr<CCfits::FITS> EventFileTemplate(const std::string& filename);
std::unique_ptr<CCfits::FITS> ImpactFileTemplate(const std::string& filename);
std::unique_ptr<CCfits::FITS> PixImpactFileTemplate(const std::string& filename);
std::unique_ptr<CCfits::FITS> PhotonFileTemplate(const std::string& filename);


} // sixte
