/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2023 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#pragma once

#include "SixteVector.h"

namespace sixte {

struct Telescope_attitude {
  Telescope_attitude() = default;
  Telescope_attitude(SixteVector nx_in, SixteVector ny_in, SixteVector nz_in);
  
  /** Unit vectors defining the telescope attitude. */
  /** Usually points in the direction of motion, but is perpendicular to nz. */
  SixteVector nx;
  /** Perpendicular to nx and nz */
  SixteVector ny;
  /** Direction of the telescope axis (in simplest case same direction as r). */
  SixteVector nz;
};

} // sixte
