/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2023 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#include "SixteTesEventFile.h"

namespace sixte {

TesEventFile *initTesEventFile(const string &filename, bool clobber, const ObsInfo &obs_info) {
  int status = EXIT_SUCCESS;
  
  SixtStdKeywords *keys = buildSixtStdKeywords(
    const_cast<char *>(obs_info.telescop.c_str()),
    const_cast<char *>(obs_info.instrume.c_str()),
    const_cast<char *>(obs_info.filter.c_str()),
    const_cast<char *>(obs_info.ancrfile.c_str()),
    const_cast<char *>(obs_info.respfile.c_str()),
    NULL,
    obs_info.mjdref,
    obs_info.timezero,
    obs_info.tstart,
    obs_info.tstop,
    &status);
  checkStatusThrow(status, "Failed creating SixtStdKeywords");
  
  char clobber_char = 1;
  if (!clobber) clobber_char = 0;

  TesEventFile *event_file = opennewTesEventFile(filename.c_str(), keys, clobber_char, &status);
  checkStatusThrow(status, "Failed opening TesEventFile");
  
  freeSixtStdKeywords(keys);
  
  fits_update_key(event_file->fptr, TDOUBLE, "EXPOSURE", (double *) &(obs_info.total_sim_time),
                  "exposure time [s]", &status);
  checkStatusThrow(status, "Failed to update event file keywords");
  
  obs_info.pointing.addPointingInfo(event_file->fptr);
  
  return event_file;
}

}