/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2007-2014 Christian Schmid, FAU
   Copyright 2015-2019 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                       Erlangen-Nuernberg
*/

#pragma once

#include "Polygon.h"

extern "C" {
#include "vector.h"
}


namespace sixte {

struct Point2d {
  double x, y;
};

/** Impact of a photon on the detector plane. */
struct Impact {
  /** Arrival time of the photon on the detector [s]. */
  double time;
  /** Photon energy [keV]. */
  float energy;
  /** Impact position of the photon on the detector [m]. */
  struct Point2d position;
  /** Unique photon identifier. */
  long ph_id;
  /** Unique source identifier for the originating X-ray source. */
  long src_id;
  long tel_id;
};

enum class AttNxAlign {
  /** Alignment of the nx vector of the RAWX/RAWY coordinate system
      along the north direction. */
  ATTNX_NORTH =0,
  
  /** Alignment of the nx vector along the direction of motion of the
      pointing axis. */
  ATTNX_MOTION=1,
};

struct lissajous_pattern_struct {
  std::vector<double> time, x_val, y_val;
};

}