/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2022 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#pragma once

#include <memory>

namespace sixte {

class Progressbar {
 public:
  explicit Progressbar(bool show_progressbar, double expected_counts);
  ~Progressbar();

  void update(double current_count);
  void finish();

 private:
  bool show_{false};

  double expected_counts_;
  unsigned int n_steps_{100};
  unsigned int progress_{1};
};

}
