/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2022 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#include "SixteProgressbar.h"
#include "healog.h"
#include <unistd.h>

namespace sixte {

Progressbar::Progressbar(bool show_progressbar, double expected_counts)
    : show_{show_progressbar}, expected_counts_{expected_counts}
{}

void Progressbar::update(double current_count) {
  if (show_) {
    while (current_count >= progress_ * expected_counts_ / n_steps_) {
      ++progress_;
      // We only write this if we're not e.g. piping to a file
      // Note that if we quit out early, the destructor will catch this
      // and write where we're stopped, even outside a tty
      if (isatty(fileno(stdout))) {
        std::cout << progress_ << "\%\r";
        std::cout.flush();
      }
    }
  }
}

void Progressbar::finish() {
  update(expected_counts_);
  healog(3) << "Done!\n";
}

Progressbar::~Progressbar() {
  if (progress_<100) {
    // in case we abort early (e.g. due to an exception)
    // report where we stopped - might be useful for debugging
    std::cout << "Stopped at " << progress_ << "%";
  }
  healog(3) << '\n';
}

}
