/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2023 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#include "SixtePhoton.h"

namespace sixte {

SixtePhoton pop_next_photon(SixtePhotons& photons) {
  if (photons.empty()) {
    throw SixteException("Photon queue is empty");
  }
  auto next_photon = photons.top();
  photons.pop();
  return next_photon;
}

void SixtePhoton::setTelID(size_t tel_id) {
  photon_metainfo_.tel_id_ = tel_id;
}

void SixtePhoton::setChipID(size_t chip_id) {
  photon_metainfo_.chip_id_ = chip_id;
}
}

