/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2022 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#pragma once

#include <exception>
#include <iostream>
#include <string>
#include <string_view>

namespace sixte {

class SixteException : public std::runtime_error {
 public:
  explicit SixteException(const std::string& error_message)
      : std::runtime_error(error_message) {}
};

/**
 * Prints an error message on standard error.
 *
 * @param message    The message to print.
 */
void printError(const std::string& error_message);

void printWarning(const std::string& warning_message);

void checkStatusThrow(int status, std::string_view error_message);

}