/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2022 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#include "SixteException.h"
#include "healog.h"

namespace sixte {

void printError(const std::string& error_message) {
  std::cerr << "Error: " << error_message << '\n';
}

void printWarning(const std::string& warning_message) {
  healog(3) << "### Warning: " << warning_message << "!\n";
}

void checkStatusThrow(int status, std::string_view error_message) {
  if (status != EXIT_SUCCESS)
    throw SixteException(std::string(error_message));
}

}