#pragma once

#include <utility>
#include <vector>
#include "ArrayGeometry.h"
#include "Carrier.h"
#include "EnergyDeposition.h"
#include "Ebounds.h"
#include "NewRMF.h"
#include "NewVignetting.h"
#include "raytracing/mirror_module/LobsterEyeOptic.h"

extern "C" {
#include "phabkg.h"
}

namespace sixte {

PHABkg* newPHABkgWrapper(const std::string& phabkg_fullpath, const NewRMF& rmf);

struct PHABkgDeleter {
  void operator()(PHABkg* phabkgptr) const;
};

using PHABkgUniquePtr = std::unique_ptr<PHABkg, PHABkgDeleter>;

class PHABackground {
 public:
  PHABackground(const XMLData& xml_data,
                std::shared_ptr<ArrayGeometry> sensor_geometry,
                std::shared_ptr<const Ebounds> canonical_ebounds,
                size_t tel_id, size_t chip_id);

  CarrierPtr getNextBkgCarrier(const std::pair<double, double>& dt);

 private:
  [[nodiscard]] double calcOffaxisAngle(const Point_2& position) const;
  [[nodiscard]] static double calcAzimuthAngle(const Point_2& position) ;

  std::shared_ptr<const NewRMF> rmf_;
  PHABkgUniquePtr phabkg_;
  std::optional<NewVignetting> vignetting_{std::nullopt};
  double focal_length_;
  std::shared_ptr<ArrayGeometry> sensor_geometry_;

  size_t tel_id_;
  size_t chip_id_;

  std::optional<LobsterEyeOptic> lobster_eye_optic_;
};

}
