/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2022 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#pragma once

#include "Parameters.h"

namespace sixte {

class SimulationParameters {
 public:
  SimulationParameters();

  InputFiles input_files;
  OutputFiles output_files;
  ObsPointing pointing;
  ObsTime time;
  
  bool skip_invalids;
  bool background;
  bool calibration_source;
  double attitude_dt;
  int seed;
  bool show_progress;
};

}
