/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2023 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#pragma once

#include "SixteCCFits.h"
#include <string>

extern "C" {
  #include "region.h"
}

namespace sixte {

/**
 * Build a region for region filtering based on an input file and an Event HDU
 *
 * This function checks the HDU for the relevant columns (X and Y) and reads header
 * keywords and builds an SAORegion
 *
 * An SixteException is thrown if any needed columns or header keywords are missing
 *
 * @param regfile Filename of the region definition file
 * @param hdu     Extension to read data from
 * @return        An allocated SAORegion
 */
SAORegion* getRegion(const std::string &regfile, CCfits::ExtHDU &hdu);

/**
 * Apply a region filter to two coordinates
 *
 * @param region  SAORegion pointer
 * @param X       X coordinate
 * @param Y       Y coordinate
 * @return        true if (X,Y) is within the region, false if not
 */
bool filterReg(SAORegion *region, double X, double Y);

}
