/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2022 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#pragma once

// Kernel
#include <CGAL/Exact_predicates_inexact_constructions_kernel.h>
typedef CGAL::Exact_predicates_inexact_constructions_kernel cgal_Kernel;

// 2D polygons
#include <CGAL/Polygon_2.h>
typedef CGAL::Polygon_2<cgal_Kernel> Polygon_2;

// 2D points
typedef cgal_Kernel::Point_2 Point_2;

// 3D points
typedef cgal_Kernel::Point_3 Point_3;

// 2D vectors
typedef cgal_Kernel::Vector_2 Vector_2;

// 3D vectors
#include <CGAL/Vector_3.h>
typedef cgal_Kernel::Vector_3 Vector_3;

// 3D vectors
typedef cgal_Kernel::Vector_3 Vector_3;

// 2D directions
typedef cgal_Kernel::Direction_2 Direction_2;

// 2D affine transformations
#include <CGAL/Aff_transformation_2.h>
typedef CGAL::Aff_transformation_2<cgal_Kernel> Transformation_2;
