#include "Pixel.h"

namespace sixte {

std::unique_ptr<Pixel> createPixel(XMLData& xml_data, std::optional<double> frame_duration,
                                   std::optional<T_PixId> pix_id,
                                   std::optional<std::shared_ptr<LineInfo>> line_info) { // TODO: Clean up arguments
  // TODO: Use enum+switch
  auto type = xml_data.child("detector").attributeAsString("type");

  if (type == "ccd") {
    return std::make_unique<SimplePixel>();
  }

  if (type == "depfet") {
    return std::make_unique<DEPFETPixel>(xml_data, *frame_duration, *pix_id, *line_info);
  }

  throw SixteException("Failed to read pixel type");
}

}
