/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2022 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#pragma once

#include "ArrayGeometry.h"
#include "Geometry.h"
#include "NewAttitude.h"
#include "NewEventfile.h"
#include "paraminput.h"
#include "SixteException.h"
#include "XMLData.h"

extern "C" {
#include "sixt.h"
}

namespace sixte {

class PhotonProjection {
 public:
  explicit PhotonProjection(XMLData& xml_data);

  // void rectPhproj(NewAttitude& attitude,
  //                 NewEventfile& eventfile,
  //                 double tstart, double tstop) const;
  //
  [[nodiscard]] std::pair<double, double> projectRectEvent(size_t rawx, size_t rawy,
                                                       const Telescope_attitude& telescope_attitude) const;

  void doRectangularPhotonProjection(NewAttitude& attitude,
                                     NewEventfile& eventfile,
                                     double tstart,
                                     double tstop) const;
  
  /**
   * Project photon origin vector onto the telescope reference system
   * @param origin origin vector of imaged photons
   * @param telescope_attitude telescope attitude
   * @return normalized projected vector
   */
  [[nodiscard]] static std::pair<double, double> projectRectTheseusEvent(const SixteVector& origin,
                                                                         const Telescope_attitude& telescope_attitude);

 private:
  /**
   * Calculate position in m in absolute reference to xrpix / yrpix.
   * @param rawx Pixel value in x
   * @param rawy Pixel value in y
   * @return Detector position
   */
  [[nodiscard]] std::pair<double,double> getRectRandPosInPixel(size_t rawx, size_t rawy) const;
    
 private:
  double rotation_angle_;
  double xrpix_, yrpix_;
  double xdelt_, ydelt_;
  double xrval_, yrval_;
  double focal_length_;
  double cosrota_;
  double sinrota_;
  bool isTheseus_ = false;
};

void doMicroCalPhotonProjection(NewAttitude& attitude, const Geometry& absorber_geometry, const ArrayGeometry& array_geometry,
                                double focal_length, fitsfile *fptr, double tstart, double tstop);

}
