/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2025 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#pragma once

#include <optional>
#include <utility>
#include "SixteVector.h"

namespace sixte {

// TODO: Use enum class
enum SrcType {
  pha_bkg = -1,
  aux_bkg = -2,
  mxs = -3
};

enum PhId {
  pha_bka_id = -1,
  aux_bkg_id = -2,
  mxs_id = -10
};

class PhotonMetainfo {
 public:
  PhotonMetainfo(long ph_id, long src_id, size_t tel_id, size_t chip_id, SixteVector origin)
      : ph_id_(ph_id), src_id_(src_id), tel_id_(tel_id), chip_id_(chip_id), origin_(origin) {}

  PhotonMetainfo(long ph_id, long src_id, size_t tel_id, size_t chip_id)
  : ph_id_(ph_id), src_id_(src_id), tel_id_(tel_id), chip_id_(chip_id) {}

  PhotonMetainfo(long ph_id, long src_id, size_t tel_id)
  : ph_id_(ph_id), src_id_(src_id), tel_id_(tel_id) {}

  PhotonMetainfo(long ph_id, long src_id)
  : ph_id_(ph_id), src_id_(src_id) {}

  PhotonMetainfo() = default;

  void setIncidentAnglesRad(double theta_rad, double phi_rad);
  [[nodiscard]] std::optional<std::pair<double,double>> incidentAnglesRad() const;
  [[nodiscard]] std::optional<std::pair<double,double>> incidentAnglesDeg() const;

  // Unique photon identifier.
  long ph_id_;

  // Unique source identifier for the originating X-ray source.
  long src_id_;

  // ID of the imaging telescope.
  size_t tel_id_{0};

  size_t chip_id_{0};

  std::optional<SixteVector> origin_;

 private:
  std::optional<std::pair<double,double>> incident_angles_rad_;
};

}
