/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2025 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#include "PhotonMetainfo.h"
#include <cmath>

namespace sixte {

void PhotonMetainfo::setIncidentAnglesRad(double theta_rad, double phi_rad) {
  incident_angles_rad_.emplace(theta_rad, phi_rad);
}

std::optional<std::pair<double,double>> PhotonMetainfo::incidentAnglesRad() const {
  return incident_angles_rad_;
}

std::optional<std::pair<double,double>> PhotonMetainfo::incidentAnglesDeg() const {
  if (!incident_angles_rad_) return std::nullopt;
  const double theta_deg = incident_angles_rad_->first * 180.0 / M_PI;
  const double phi_deg = incident_angles_rad_->second * 180.0 / M_PI;
  return std::make_pair(theta_deg, phi_deg);
}

} // namespace sixte
