/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2022 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#pragma once

#include "NewAttitude.h"
#include "NewArf.h"
#include "NewPhotonfile.h"
#include "NewSourceCatalog.h"
#include "ObsInfo.h"
#include "Parameters.h"
#include "SixtePhoton.h"
#include <optional>
#include <string>
#include <vector>

extern "C" {
#include "sourcecatalog.h"
}

namespace sixte {

class PhotonGeneration {
 public:
  PhotonGeneration(const std::vector<std::string>& photon_lists, bool clobber,
                   const std::vector<std::string>& simput_files,
                   std::vector<XMLData>& xml_datas,
                   const std::vector<ObsInfo>& obs_infos);

  std::optional<SixtePhoton> getNextPhoton(NewAttitude& attitude,
                                           std::pair<double, double> dt);

 private:
  size_t num_tels_;
  bool write_photon_file_ = false;
  std::vector<PhotonFile> photon_file_;
  NewArf arf_;
  std::vector<NewSourceCatalog> source_catalog_;
  
  std::optional<SixtePhoton> phgen(std::pair<double, double> dt, NewAttitude& attitude);
  
  double fov_diameter_rad_;
};

std::vector<std::string> getARFFilenames (std::vector<XMLData>& xml_datas);

size_t getIDofXMLwithLargestFOV(std::vector<XMLData>& xml_datas) ;

}
