/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2022 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#include "Pha2PiCorrection.h"
#include "SixteException.h"

namespace sixte {

Pha2PiCorrection::Pha2PiCorrection(XMLData& xml_data) {
  rsp_path_ = xml_data.dirname();
  rsp_file_ = xml_data.child("detector").child("rmf").attributeAsString("filename");

  std::string pha2pi_filename;
  if (auto pha2pi_elem = xml_data.child("telescope").optionalChild("pha2pi")) {
    pha2pi_filename = xml_data.dirname() + pha2pi_elem->attributeAsString("filename");
  }

  std::string pirmf_filename;
  if (auto pirmf_elem = xml_data.child("telescope").optionalChild("pirmf")) {
    pirmf_filename = pirmf_elem->attributeAsString("filename");
  }

  std::string specarf_filename;
  if (auto specarf_elem = xml_data.child("telescope").optionalChild("specarf")) {
    specarf_filename = specarf_elem->attributeAsString("filename");
  }

  int status = EXIT_SUCCESS;
  if (!pha2pi_filename.empty()) {
    p2p_ = NewPha2Pi(pha2pi_filename, pirmf_filename, specarf_filename);
  }
  checkStatusThrow(status, "Failed to initialize pha2pi correction");
}

void Pha2PiCorrection::correctEventfile(NewEventfile& evtfile) {
  if (p2p_) {
    healog(3) << "start Pha2Pi correction ...\n";
    p2p_->pha2piCorrectEventfile(evtfile, rsp_path_, rsp_file_);
  }
}

}
