/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2022 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#pragma once

#include "ObsInfo.h"
#include "NewEventfile.h"
#include "SixteException.h"
#include "XMLData.h"
#include "Ebounds.h"

extern "C" {
#include "event.h"
#include "sixt.h"
}

namespace sixte {

class PatternStatistics {
 public:
  PatternStatistics() = default;
  /** Number of valid patterns. */
  long nvalids{0};
  /** Number of valid patterns flagged as pile-up. */
  long npvalids{0};
  
  /** Number of invalid patterns. */
  long ninvalids{0};
  /** Number of invalid patterns flagged as pile-up. */
  long npinvalids{0};
  
  /** Number of patterns with a particular grade. */
  std::vector<long> ngrade;
  /** NUmber of patterns with a particular grade flagged as
      pile-up. */
  std::vector<long> npgrade;
};

class PatternAnalysis {
 public:
  PatternAnalysis(bool skip_invalids,
                  XMLData& xml_data,
                  size_t rawymin, size_t rawymax);


  void phpat(const Ebounds& ebounds, NewEventfile& src_file, NewEventfile& dst_file);

 private:
  void patternAnalysisOfNewframe(std::list<NewEvent>& framelist,
                                 bool iseROSITA,
                                 bool threshold_warning_printed,
                                 const Ebounds& ebounds,
                                 PatternStatistics& statistics,
                                 NewEventfile& dst_file);
  
  static void getEventType(NewEvent& new_event, size_t size, bool touched_border);
  static int getDoubleType(const std::vector<double>& signals) ;
  static int getTripleType(const std::vector<double>& signals) ;
  static int getQuadrupleType(const std::vector<double>& signals) ;
  
  static void savePixelContribution(const NewEvent& neighbor, const NewEvent& max_ev, NewEvent& new_event);
  
  static NewEvent findMaxSignalPixel(const std::list<NewEvent>& neighborlist);
  
  static void findNeighborEvents(std::list<NewEvent>& framelist,
                          std::list<NewEvent>& neighborlist,
                          double split_threshold,
                          size_t maxnneighborlist);
  
  [[nodiscard]] bool checkForBorderPixels(const NewEvent& neighbor) const;
  
  [[nodiscard]] double getSplitPatternThreshold(const std::list<NewEvent>& framelist, const NewEvent& maxsignalev, bool iseROSITA) const;
  
  static NewEvent findNeighborMaxEvent(const std::list<NewEvent>& framelist,
                                       const std::list<NewEvent>& neighborlist);

  static void emptyPixelList(std::list<NewEvent>& event_list);
  
  static void setPHandSRCid(NewEvent& new_event, const NewEvent& neighbor);

  static void updatePatternStatistics(const NewEvent& event, PatternStatistics& statistics);
  [[nodiscard]] bool checkUpperThreshold(const NewEvent& event) const;
  void addEvent2File(const NewEvent& event, NewEventfile& dst_file);
  
  const size_t num_patterns = 13;
  

  double threshold_event_lo_keV_{0.};
  double threshold_split_lo_keV_{0.};
  double threshold_split_lo_fraction_{0.};
  double threshold_pattern_up_keV_{0.};

  size_t xwidth_;
  size_t rawymin_, rawymax_;

  bool skip_invalids_;
};




}
