/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2024 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#pragma once

#include "SixteException.h"
#include "atmsp.h"
#include <string>
#include <sstream>


namespace sixte {

/**
  * Parses the given mathematical expression using the ATMSP library
  * @param expr         String containing math expression
  *
  * @return             The resulting value
  */
template<typename T>
T parse_mathstring(const std::string& expr) {
  ATMSB<T> byteCode;
  ATMSP<T> parser;

  size_t err= parser.parse(byteCode, expr, "");

  // NOTE: The currently empty string argument above could be used to add
  //       mathematical constants - for example, adding the string "pi"
  //       plus the line of code
  //       byteCode.var[0] = M_PI;
  //       would allow users to use that constant in their expressions

  if (err) {
    std::stringstream msg;

    msg << "Math expression [" << expr << "] from XML is invalid, with parse errror\n  "
        << parser.errMessage(err);

    throw(SixteException(msg.str()));
  }

  return byteCode.run();
}

}
