/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.

   Copyright 2022 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#pragma once

#include "paraminput.h"
#include "SixteCCFits.h"
#include "SixteException.h"

#include "headas_stdio.h"
#include "pugixml.hpp"
#include <string>
#include <boost/algorithm/string/predicate.hpp>
#include <vector>
#include <sstream>
#include <optional>

namespace sixte {

bool isNone(const std::string& parameter_name);

class InputFiles {
 public:
  InputFiles();

  std::vector<pugi::xml_document> xml_files;
  std::vector<pugi::xml_document> xml_tel_files;
  std::string xml_path;
  std::vector<std::string> simput_files;
  std::string gti_file;

  size_t num_xmls;
  size_t num_tels;
  std::vector<size_t> num_chips;
};

class OutputFiles {
 public:
  OutputFiles() = default;

  // constructor where default values can be specified within the program
  OutputFiles(
    std::optional<std::string> o_prefix,
    std::optional<std::string> o_photon_list,
    std::optional<std::string> o_impact_list,
    std::optional<std::string> o_evt_file,
    std::optional<std::string> o_raw_data,
    std::optional<bool> o_clobber);


  std::string prefix;
  std::vector<std::string> photon_lists;
  std::vector<std::string> impact_lists;
  std::vector<std::string> evt_files;
  std::vector<std::string> raw_datas;

  bool delete_rawdata;
  bool clobber;
};

struct ObsPointing {
  ObsPointing();
  ObsPointing(std::string  attitude_file_, double ra_, double dec_, double rollangle_);

  void addPointingInfo(CCfits::ExtHDU& ext_hdu) const;
  void addPointingInfo(Fitsfile& fitsfile) const;
  void addPointingInfo(fitsfile *fptr) const;

  std::string attitude_file{};
  double ra{};
  double dec{};
  double rollangle{};
};

struct ObsTime {
  ObsTime();
  ObsTime(double mjdref_, double tstart_, double exposure_);

  double mjdref{};
  double tstart{};
  double exposure{};
};

struct XMLDetectorFiles {
  std::vector<pugi::xml_document> xml_documents;
  std::vector<size_t> num_chips;
};

std::vector<std::string> loadSIMPUTFilenames();
std::string loadXMLPath();
XMLDetectorFiles loadXMLFiles();
XMLDetectorFiles detectorXMLs(const std::vector<std::string>& xml_filenames);

}



