/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2022 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#pragma once

#include "Parameters.h"
#include "GTICollection.h"
#include "XMLData.h"
#include "SixteCCFits.h"
#include <string>

namespace sixte {

class ObsInfo {
 public:
  ObsInfo(XMLData& xml_data, ObsPointing pointing_in, const GTICollection& gti);

  ObsPointing pointing;

  std::string telescop;
  std::string instrume;
  std::string ancrfile;
  std::string respfile;
  std::string filter;

  double mjdref;
  double tstart;
  double tstop;
  double timezero;
  double total_sim_time;
  
  void addObsInfoKeysToFile(CCfits::HDU &table) const;
};

}
