/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2022 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/
#pragma once

#include "NewArf.h"
#include "NewAttitude.h"
#include <string>

extern "C" {
#include "sourcecatalog.h"
}


namespace sixte {

/** Catalog of different X-ray sources. */
class NewSourceCatalog {
 public:
  NewSourceCatalog(const std::string& simput_file, const NewArf& arf);
  ~NewSourceCatalog();
  NewSourceCatalog(const NewSourceCatalog&) = delete;
  NewSourceCatalog(NewSourceCatalog&& other);
  NewSourceCatalog& operator=(const NewSourceCatalog&) = delete;
  NewSourceCatalog& operator=(NewSourceCatalog&& other);
  
  LinkedPhoListElement* sixteGenFoVXRayPhotons(NewAttitude& attitude, double fov, double time, double t1) const;
  //[[nodiscard]] const SourceCatalog* c_sourceCatalog() const;
  
  // TODO ideally we would only return a const pointer here
  // however, most functions that actually use SIMPUT require non-const pointers,
  // which means that returning a const pointer would be fairly useless
  SimputCtlg* simput() {
   return simput_ctlg_;
  }

 private:
  /** KDTree containing the Source objects for all point-like
    sources. */
  KDTreeElement* tree_;
  
  /** Array containing Source objects for all extended sources. */
  Source* extsources_;
  
  /** Number of entries in the linear array of extended sources. */
  size_t nextsources_;
  
  /** SIMPUT source catalog containing all relevant data. */
  SimputCtlg* simput_ctlg_;
};

}
