/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2023 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

//
// NewSixt_main.cpp: modification of headas_main.c that preserves
// argc/argv as sixt_argc and sixt_argv for those SIXT tools that
// need argc/argv access
//

// Otherwise the tool works identically to headas_main


#include "headas.h"

int sixt_argc;
char **sixt_argv;

#ifndef TOOLSUB
#error TOOLSUB is not defined
#endif

int TOOLSUB(void);

/* Universal main function. */
int main(int argc, char **argv) {
  int status = EXIT_SUCCESS;
  
  auto env_value = std::getenv("SIXTE");
  if (!env_value) {
    std::cout << "SIXTE environment variable not set!" << '\n';
    return EXIT_FAILURE;
  }
  
  sixt_argc=argc;
  sixt_argv=argv;
  
  status = headas_init(argc, argv);
  
  if(!status) status = TOOLSUB();
  
  status = headas_close(status);
  
  return status;
}