/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2023 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#pragma once

#include "NewEventfile.h"
#include "NewRMF.h"
#include <string>

extern "C" {
#include "geninst.h"
}

namespace sixte {

/** FITS file containing the correction from PHA to PI. */
class NewPha2Pi {
 public:
  /** Initialize RNG and Load Pha2Pi structure. (Former: initPha2Pi) */
  NewPha2Pi(std::string  filename,
            const std::string& pirmf_filename,
            const std::string& specarf_filename);
  
  /** Initialize RNG and Load Pha2Pi structure from GenInst structure. (Former: initPha2Pi_from_GenInst) */
  explicit NewPha2Pi(GenInst* inst);
  
  /** Do the pha2pi correction on a single event. */
  void pha2piCorrectEvent(NewEvent& event, const NewRMF& rmf);

  /** Do the pha2pi correction on a eventfile. */
  void pha2piCorrectEventfile(NewEventfile& evtfile,
                              const std::string& RSPPath,
                              const std::string& RESPfile);
 
 private:
  /** FILE NAME of Pha2Pi correction File*/
  std::string pha2pi_filename_;
  
  /** FILE NAME of PI-RMF for corrected PI values*/
  std::string pirmf_filename_;
  
  /** FILE NAME of SPEC ARF for PSF-Chip coverage calibrated ARF */
  std::string specarf_filename_;
  
  /** FILE CONTENT */
  std::string rmffilecontent_;
  
  long nrows_{0};
  size_t ngrades_{0};
  
  std::vector<long> pha_;
  std::vector<std::valarray<double>> pien_;
  std::vector<std::valarray<double>> pilow_;
  std::vector<std::valarray<double>> pihigh_;
  
  /** Replacement for NULL/NaN */
  double nulval_double_{-255.};
  long nulval_long_{-255};
};



}
