/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2022 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#include "NewImpactfile.h"

#include "CCfits"
#include "healog.h"
#include "NewSIXT.h"
#include "SixteException.h"

namespace sixte{

ImpactFile::ImpactFile(const std::string& output_file, bool clobber, const ObsInfo& obs_info) {
  auto inFile = sixteOpenFITSFileWrite(output_file, clobber, true, "impact file");
  
  auto& table = inFile->pHDU();
  obs_info.addObsInfoKeysToFile(table);
  
  auto& table2 = inFile->extension(1);
  obs_info.addObsInfoKeysToFile(table2);
  
  obs_info.pointing.addPointingInfo(table2);
  
  inFile->destroy();
  
  fitsfile_ = Fitsfile(output_file, FileMode::write);
  fitsfile_.moveToExt("IMPACTS");
}

void ImpactFile::addImpact2File(const SixtePhoton& photon) {
  const auto row_num = fitsfile_.getNumRows() + 1;
  
  double photime = photon.time();
  double phoenergy = photon.energy();
  double phox = photon.detector_position()->x();
  double phoy = photon.detector_position()->y();
  long phoid = photon.photon_metainfo().ph_id_;
  long phosrc = photon.photon_metainfo().src_id_;

  fitsfile_.writeCol("TIME", row_num, photime);
  fitsfile_.writeCol("ENERGY", row_num, phoenergy);
  fitsfile_.writeCol("X", row_num, phox);
  fitsfile_.writeCol("Y", row_num, phoy);
  fitsfile_.writeCol("PH_ID", row_num, phoid);
  fitsfile_.writeCol("SRC_ID", row_num, phosrc);
}

}
