/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2022 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/


#pragma once

#include "XMLData.h"
#include <string>

#include "arf.h"

namespace sixte {

class NewArf {
 public:
  explicit NewArf (const std::vector<std::string>& arf_filenames);
  ~NewArf();
  
  [[nodiscard]] const struct ARF* c_arf() const;
  std::vector<std::vector<double>> retCumulARF ();
  
  size_t getTelescopeID (double energy);
  long findArfBinIndex(double energy);

 private:
  void addARFsToMultiTelARF(std::vector<ARF*> arfs);
  void getCumulARF(std::vector<ARF*> arfs);

  struct ARF* arf_;
  std::vector<std::vector<double>> cumulARF_;
  size_t num_arfs_{1};
  std::vector<float> arf_energy_grid_lo_;
};



}

///** get a ARF from arrays
//    low_energy, high_energy and eff_area all needto have NumberEnergyBins elements. */
//  static struct ARF *sixtegetARFfromarrays(long NumberEnergyBins,
//                                    const std::vector<float>& low_energy,
//                                    const std::vector<float>& high_energy,
//                                    const std::vector<float>& eff_area,
//                                    const std::string& telescope);
//
///** Load an ARF from a response file. */
//  static struct ARF *sixteloadARF(const std::string& filename);
//
///** Destructor for the ARF data structure. Warning: As there is no
//    internal destructor for the ARF data structure in the HEASP
//    library, the memory allocated by the function ReadARF is released
//    by a self-implemented function, which is not guaranteed to work
//    properly. */
//  static void sixtefreeARF(struct ARF *arf);