/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2024 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#pragma once

#include "ArrayGeometry.h"
#include <vector>

namespace sixte {

class LineInfo {
 public:
  LineInfo(size_t num_lines,
           std::vector<unsigned int>  lines_of_pix_ids);

  double lastReadoutTime(T_PixId pix_id);
  void setLastReadoutTime(unsigned int lineindex, double time);
  void addLastReadoutTime(unsigned int lineindex, double time);

 private:
  std::vector<unsigned int> lines_of_pix_ids_;
  std::vector<double> line_last_readout_time_; // TODO: Double-check consistent usage of lineindex
};

}