/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2024 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#include "LineInfo.h"

#include <utility>

namespace sixte {

LineInfo::LineInfo(size_t num_lines,
                   std::vector<unsigned int>  lines_of_pix_ids)
    : lines_of_pix_ids_(std::move(lines_of_pix_ids)) {
  line_last_readout_time_.assign(num_lines, 0);
}

double LineInfo::lastReadoutTime(T_PixId pix_id) {
  return line_last_readout_time_[lines_of_pix_ids_[pix_id]];
}

void LineInfo::setLastReadoutTime(unsigned int lineindex, double time) {
  line_last_readout_time_[lineindex] = time;
}

void LineInfo::addLastReadoutTime(unsigned int lineindex, double time) {
  line_last_readout_time_[lineindex] += time;
}

}