/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2022 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#pragma once
#include "BoundingBox.h"
#include "Polygon.h"
#include "XMLData.h"

namespace sixte {

class Geometry {
 public:
  Geometry(XMLData& xml_data, const std::optional<BoundingBox2d>& bounding_box_det = std::nullopt);
  Geometry(double xrval, double yrval, double rota, const std::optional<BoundingBox2d>& bounding_box_det = std::nullopt);

  double xrval_;
  double yrval_;
  double rota_;


  [[nodiscard]] SixtePoint transformFocalToDet(const SixtePoint& pos) const;

  [[nodiscard]] SixtePoint transformDetToFocal(const SixtePoint& pos) const;

  [[nodiscard]] bool contains(const SixtePoint& photon_det_position) const;
 private:
  std::optional<BoundingBox2d> bounding_box_det_{std::nullopt};

  // affine transformation matrix for focal plane to detector
  SixteAffTransformation3 focal_to_det_;

  // affine transformation matrix for detector to focal plane 
  SixteAffTransformation3 det_to_focal_;

  void build_transforms();
};

}
