/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.

   Copyright 2022 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#pragma once

#include "Parameters.h"
#include "SixteException.h"

extern "C" {
#define new extern_new
#include "gti.h"
#undef new
}

namespace sixte {

class GTICollection {
 public:
  GTICollection(const std::string& gti_filename, const ObsTime& obs_time);

  GTICollection(const std::string& gti_filename);

  // apply the given GTI collection as a filter to this GTICollection
  // Effectively, this means computing a logical AND
  void filterWith(GTICollection &filter);

  // TODO: Implement remaining constructors (Rule of 5)
  ~GTICollection();

  std::vector<std::pair<double, double>> getAllGtiBins() const;

  void saveGtiExtension(fitsfile *const fptr) const;

  void saveGtiExtension(fitsfile *const fptr,
    std::string const& telescop, std::string const& instrume) const;

  [[nodiscard]] double tstartFirstGti() const {
    return gti_->start[0];
  }

  [[nodiscard]] double tstopLastGti() const {
    return gti_->stop[gti_->ngti - 1];
  }

  [[nodiscard]] double mjdref() const {
    return gti_->mjdref;
  }

  [[nodiscard]] double timezero() const {
    return gti_->timezero;
  }

  [[nodiscard]] double totalExposure() const {
    return sumGTI(gti_);
  }

 private:
  GTI *gti_;
};

}
