/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2022 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#include "FrameProcessor.h"

namespace sixte {

template<typename T>
double calcMedian(std::vector<T> vec) {
  size_t size = vec.size();
  assert(size != 0);

  std::sort(std::begin(vec), std::end(vec));
  if (size % 2 == 0) {
    return (vec[size / 2 - 1] + vec[size / 2]) / 2.;
  } else {
    return vec[size / 2];
  }
}

void printSliceSignal(const SliceSignal& slice_signal) {
  for (const auto& pixel_signal: slice_signal) {
    std::cout << "pix_id " << pixel_signal.pix_id << ": " << pixel_signal.signal << std::endl;
  }
  std::cout << '\n';
}

void printLineSignal(const LineSignal& line_signal) {
  for (size_t slice = 0; slice < line_signal.size(); slice++) {
    std::cout << "Slice " << slice << '\n';
    printSliceSignal(line_signal[slice]);
  }
}

void printSliceData(const SliceData& slice_data) {
  for (const auto& pixel_data: slice_data) {
    std::cout << pixel_data.signal().to_ulong() << " ";
  }
  std::cout << std::endl;
}

void printLineData(const LineData& line_data) {
  for (size_t slice = 0; slice < line_data.size(); slice++) {
    std::cout << "Slice " << slice << std::endl;
    printSliceData(line_data[slice]);
  }
}

}
