/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2022 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#pragma once

#include <memory>
#include <utility>
#include "PhotonMetainfo.h"
#include "Polygon.h"

namespace sixte {

struct EnergyDeposition {
  EnergyDeposition(double energy,
                   SixtePoint position,
                   const PhotonMetainfo& photon_metainfo,
                   double creation_time)
      : energy_(energy),
        position_(std::move(position)),
        photon_metainfo_(photon_metainfo),
        creation_time_{creation_time}{}

  double energy_;
  SixtePoint position_;
  PhotonMetainfo photon_metainfo_;
  double creation_time_;
};

using EnergyDepositions = std::vector<EnergyDeposition>;

}
