/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2025 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#pragma once
#include <cstddef>
#include <string>
#include <utility>
#include <vector>

namespace sixte {

class Ebounds {
 public:
  Ebounds(std::vector<double> e_lo_keV, std::vector<double> e_hi_keV,
          long first_channel, std::string source_filename);

  [[nodiscard]] long firstChannel() const;
  [[nodiscard]] size_t numberChannels() const;

  [[nodiscard]] double energyLo(size_t bin) const;
  [[nodiscard]] double energyHi(size_t bin) const;

  [[nodiscard]] std::pair<double, double> sixteGetEBOUNDSEnergyLoHi(long channel) const;
  [[nodiscard]] double sixteGetEBOUNDSEnergy(long channel) const;
  [[nodiscard]] long sixteGetEBOUNDSChannel(double e_keV) const;

 private:
  [[nodiscard]] long channelForEnergy(double e_keV) const;

  std::vector<double> e_lo_;
  std::vector<double> e_hi_;
  long first_channel_;
  std::string source_filename_;
};

}  // namespace sixte
