/*
This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2022 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#pragma once

#include "Absorber.h"
#include "Ebounds.h"
#include "NewAttitude.h"
#include "ObsInfo.h"
#include "Registry.h"
#include "Sensor.h"
#include "SimulationParameters.h"
#include "SixtePhoton.h"
#include "XMLData.h"

namespace sixte {

class Detector {
 public:
  Detector(XMLData& xml_data, const OutputFiles& outfiles,
           const ObsInfo& obs_info, bool skip_invalids, size_t xml_id,
           size_t chip_id, const std::shared_ptr<RmfRegistry>& rmf_registry);

  void propagateReadout(double tstop);
  void addCarrier(const Carrier& carrier);
  void clearSensor();
  void setSensorStartTime(double tstart);

  void finishSimulation(double tstop);

  void postprocessing(NewAttitude& attitude, const GTICollection& gti);

  Carriers absorb(const SixtePhoton& photon);
  Carriers absorbEnergy(EnergyDepositions energy_depositions);

  std::shared_ptr<ArrayGeometry> sensorGeometry();
  std::shared_ptr<Geometry> absorberGeometry();
  [[nodiscard]] std::shared_ptr<const Ebounds> canonicalEbounds() const;

 private:
  Absorber absorber_;
  std::unique_ptr<Sensor> sensor_;
  std::shared_ptr<const Ebounds> canonical_ebounds_;
  size_t chip_id_;
};

}  // namespace sixte
