/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2022 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#pragma once

#include <vector>

namespace sixte {

template<typename T>
class CircularBuffer {
 public:
  void addElement(const T& new_element) {
    elements_.push_back(new_element);
    n_elements_++;
  }

  T currentElement() const {
    return elements_[current_element_id_];
  }

  T nextElement() {
    current_element_id_++;

    if (current_element_id_ == n_elements_)
      current_element_id_ = 0;

    return elements_[current_element_id_];
  }

 private:
  std::vector<T> elements_;
  size_t n_elements_{0};
  size_t current_element_id_{0};
};

}