/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2022 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#pragma once

#include "Geometry.h"
#include "SixtePhoton.h"
#include "PhotonInteractionStrategy.h"
#include "Carrier.h"

namespace sixte {

class Absorber {
 public:
  void setPhotonInteractionStrategy(std::unique_ptr<PhotonInteractionStrategy> &&strategy);

  void setCarrierFormationStrategy(std::unique_ptr<CarrierFormationStrategy> &&strategy);

  void setGeometry(XMLData& xml_data, const BoundingBox2d& bounding_box);
  void setChipId(size_t chip_id);

  /**
   * Simulates the interaction of a photon within the absorber.
   *
   * @param photon    A photon impact on the absorber.
   * @return          The carriers created from the interaction of the photon
   *                  within the absorber.
   */
  [[nodiscard]] Carriers absorb(const SixtePhoton& photon);
  [[nodiscard]] Carriers absorbEnergy(std::vector<EnergyDeposition>& energy_depositions);

  std::shared_ptr<Geometry> geometry();
  [[nodiscard]] size_t chipId() const;

 private:
  std::unique_ptr<PhotonInteractionStrategy> interaction_strategy_;
  std::unique_ptr<CarrierFormationStrategy> carrier_strategy_;
  std::shared_ptr<Geometry> absorber_geometry_;
  size_t chip_id_;
};

}
