/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2022 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#include "Absorber.h"

namespace sixte {

void Absorber::setPhotonInteractionStrategy(std::unique_ptr<PhotonInteractionStrategy>&& strategy) {
  interaction_strategy_ = std::move(strategy);
}

void Absorber::setCarrierFormationStrategy(std::unique_ptr<CarrierFormationStrategy>&& strategy) {
  carrier_strategy_ = std::move(strategy);
}

void Absorber::setGeometry(XMLData& xml_data, const BoundingBox2d& bounding_box) {
  absorber_geometry_ = std::make_shared<Geometry> (Geometry(xml_data, bounding_box));
}

Carriers Absorber::absorb(const SixtePhoton& photon) {
  auto energy_depositions = interaction_strategy_->doInteraction(*absorber_geometry_,
                                                                 photon);
  return absorbEnergy(energy_depositions);
}

Carriers Absorber::absorbEnergy(std::vector<EnergyDeposition>& energy_depositions) {
  // TODO: Use coupling matrix
  for (EnergyDeposition& energy_deposition : energy_depositions) {
    energy_deposition.photon_metainfo_.chip_id_ = chip_id_;
  }

  return carrier_strategy_->createCarriers(*absorber_geometry_,
                                           std::move(energy_depositions));
}

std::shared_ptr<Geometry> Absorber::geometry() {
  return absorber_geometry_;
}

void Absorber::setChipId(size_t chip_id) {
  chip_id_ = chip_id;
}

size_t Absorber::chipId() const {
  return chip_id_;
}

}
