version [3.3.1]
  - Fixes a small build issue for certain Clang compiler versions.

version [3.3.0]
  - Ray tracer added (supports Lobster Eye and Wolter optics; currently available only via specific instrument XMLs).
  - Coded mask imaging support added.
  - Vignetting now supports azimuthal (phi) dependence.
  - Instrument support updates: THESEUS SXI and XGIS.
  - Angle‑dependent RMF support added.
  - Fixes:
    - Deadtime acceptance logic corrected.
    - Rotated chip rendering fixed in xml2svg tool.
    - Empty output FITS files no longer include placeholder rows.
    - WCS lookup issue fixed that caused errors for some instruments.

version [3.2.2]
  - Hotfix: corrected XML errors in window mode definitions 
  - Added support for reading imaging type from the telescope attribute 
  - CMake: ensure std::filesystem works on GCC < 9 by linking stdc++fs

version [3.2.1]
  - Performance improvements, XMLData fluent API, PSF fix 
  
version [3.2.0]
  - Reimplement AUX background to new sixte
  - Add MJDREF to output extensions of ero_calevents 

version [3.1.2]
  - Fix backwards compatibility in gendetsim (Always reads first ExtHDU 
    of impact file, regardless of its name)
  - Add fstream include in xml2svg (fixes an install error for some users)
  - Fix bug introduced in 3.1.1 causing the exposure_map tool to miss
    pixels. Thanks to Ines for reporting!

version [3.1.1]
  - Internal changes regarding the GitLab CI
  - Inforce consistent cmake version in all libraries
  - update pugixml to 1.15
  - fix possible compiler error with the isnan function
  - fix for rectangular readout of larger charge clouds (relevant for AXIS)

version [3.1.0]
  - Internal changes regarding the GitLab CI
  - Update XML loops - now can use negative increments again. We now also support
    mathematical expressions using the ATMSP library
  - Fix Attitude Keywords reading
  - Port piximpacts tool to C++
  - Fix reading of RA/Dec in phoimg, improve performance of it and gendetsim
  - Do not use "tel" or "chip" substrings in output files when simulating a single
    telescope and chip
  - Replace progressbar with an increasing percentage counter
  - Delete now unused SIRENA scripts
  - Add selection of vignetting energy to exposure_map tool
  - Add better error messages when loading XMLs
  - Fix large memory consumption by crosstalk
  - Improve ShiftArray (AXIS, eROSITA, ...) performance
  - Internally update Geometry routines
  - Rename internal WCS library to work with some MacOS compilers - needs new SIMPUT version as well!
  - Remove overloads of unary and binary functions which used to be needed for MacOS

version [3.0.7]
  - fix a performance regression for the Rectangular ArrayGeometry
  - fix regressions in XML file loops and evaluating mathematical attributes
    from XML attributes

version [3.0.6]
  - add proper error message when background simulation is requested
    even though no phabackground is present in the XML file
  - updated internal geometry handling, speeding up microcalorimeter
    performance

version [3.0.5]
  - fix POISSERR keyword in makespec output files

version [3.0.4]
  - fix HDUCLAS1 key in makespec output files
  - fix long string header keywords in makespec output files

version [3.0.3]
  - first release of new SIXTE version
  - deprecated tools runsixt, erosim, athenawfisim and xifupipeline
  - all unit and e2e tests now run correctly

version [3.0.1 BETA]
  - Use Commas as separators for XMLFile and SIMPUT, instead
    of semicolons

version [3.0 BETA]
  - BETA release of SIXTE 3.0

version [2.7.2]
  - Several small bug fixes and optimizations.
  - Several updates to SIRENA (v.3.8.28)

version [2.7.1]
  - fix interpolation error for X-IFU ARFs in sixte_arfgen

version [2.7.0]
  - Update mac dependencies for new SIMPUT extlib versions
  - Remove Mission, Instrument and Mode parameter from Sixte tools
    and associated XML selection feature
  - tesgenimpacts: Rename parameter "mode" to "opmode"
  - Add python wrapper module (see test/e2e/python_wrapper)
  - SIRENA update to version v.3.8.24
  - xifupipeline
    * Fix crosstalk energy shifts not being applied
      to victim photons in TDM crosstalk
    * Adds MXS implementation
    * Make derivative crosstalk only apply to rows N+-1
    * Added prop3 type TDM crosstalk - affects pixel in row N+2
    * Removed implicit 1% scaling from TDM crosstalk - requires use
      of new instrument files
  - Add command-line interface to simulate auxbackground in runsixt
    and athenawfisim (key BkgEventList). Can also simulate photon
    background.
  - Support X-IFU type event files in radec2xy

version [2.6.3]
  - Fix numerical overflow error in XMM epic*_events tools
  - Make installation process compatible to zsh
  - erosim: Set TSTART default to 1.1.2020, fix bug in initialization of summed ARF
  - ero_calevents:
    * Add PHA2PI correction, add Seed parameter, -ve energy for split evt
    * Add FLAGSEL, PAT_SEL keywords
  - makespec: Set CORRFILE to same value as BACKFILE in makespec

version [2.6.2]
  - new tool: sixte_arfgen
    * ARF generator to calculate off-axis ARFs for any location and attitude.
  - updates internal handling of RMFs

version [2.6.1]
  - ero_calevents: Make SIXTE output consistent with eSASS' evtool/srctool
  - makespec
    * Add GTIFile option to produce multiple lightcurves from one eventfile
    * Add RMF consistency check
  - Add CMake support
  - Add exposure_map end-to-end test
  - Set clobber=yes as default
  - Multiple bug fixes

version [2.6.0]
  - changes input parameters of exposure_map tool
    * the exposure_map tool now uses WCS keyrecords to specify the grid on
      which the exposure map is calculated instead of an RA/Dec
      interval (previous input). See simulator manual (v1.3.10, p. 60), for
      more details.
    * for backward compatibility the old interface still works, but will not be
      actively supported anymore in the future.
  - adds new tool radec2xy
    * calculates backprojected X,Y instrument coordinates from RA/Dec sky
      coordinates and adds these coordinates to given event file.

version [2.5.12]
  - fix azimuthal angle range in get_psf_pos
  - fix attgen_dither tool (MJDREF, ALIGNMEN keywords not set in 2.5.11)

version [2.5.11]
  - adds warning if no photons were imaged
  - fixes crash upon writing INSTRUME/TELESCOP keys to GTI
    extension
  - fixes use of wrong RMF for PHA background energies if using
    an Advanced Detector XML file
  - updates erosim
    * erosim can now be given a comma separated list of filenames
      for each Simput parameter
  - updates SIRENA
    * 0-padding (8192-length filters filled in with 0's) and
      filters with preBuffer

version [2.5.10]
 - adds new tool attgen_dither which creates a Lissajous attitude
 - adds roll angle parameter for pointing observations via command line
 - adds missing std header keys to conform HEASARC
 - adjusts parameter input for runsixt. If an xml file is given,
   the parameters "Mission", "Instrument" and "Mode" are not queried anymore
 - SIRENA
   * fixes several bugs reagarding writing/reading HEADER
   * testriggerfile now compatible with RECORDS and
     TESRECORDS HDU
   * improves handling is no maximum is found for lags
   * improves list of input files handling

version [2.5.9]
 - fixes bug in last version regarding pha2pi correction
 - updates SIRENA to conform new file format of xifusim

version [2.5.8]
 - update & improve pha2pi correction handling
   * detector xml now may include a PIRMF or SPECARF
     entry to specify the pha2pi corrected RMF and the
     calibrated ARF
   * adjust makespec to automatically use PIRMF and
     SPECARF if available

version [2.5.7]
 - updates copyright and license notices
 - fixes bug in reading older vignetting files
 - changes vignetting handling (energies are interpolated linearly)
 - fixes bug in xmm timing mode

version [2.5.6]
 - ero_calevents: CORRATT Attitude changes reverted, given now
   in the Sixte system (in accordance with eSASS)
 - tessim: discard empty records at end ofsimulation
 - fix pha2pi tool crashing without message

version [2.5.5]
 - fixes bug in lib installation for Mac

version [2.5.4]
 - adds compatibitlity with new, April 2019 eRO Attitude
 - fixes Event Mode for NuSTAR simulations

version [2.5.3]
 - ero_calevents takes coord. trans. into account for attitude
   (CORRATT extension correctly written in eRO system now)
 - ero_calevents changes RAWX orientatation to eRO system
   (needs XML file update to srg-1.6.0)

version [2.5.2]
  - Pha2Pi correction automatically works with MC RMF (provided
    information is given in the XML file)
  - phogen tool warns if pseudo RNG is used (just meant for testing)
  - fixes minor bug in "psfgen" for uneven number of pixels

version [2.5.1]
  - fixes minor input reading "ero_vis"
  - updates display of e2e test setup
