#!/bin/tcsh

set simput="/home/sixte/simputArchive/tycho.simput"
set ra=6.34191510397
set dec=64.1419694802

set xmldir=`pwd`/../wfi_w_filter_baseline

echo Using SIXTE version in $SIXTE, SIMPUT in $SIMPUT
echo Using XMLs in directory: $xmldir

# Test full four Large Detectors
$SIXTE/bin/athenawfisim \
    EvtFile=test.evt \
    XMLFile0=${xmldir}/ld_wfi_ff_chip0.xml \
    XMLFile1=${xmldir}/ld_wfi_ff_chip1.xml \
    XMLFile2=${xmldir}/ld_wfi_ff_chip2.xml \
    XMLFile3=${xmldir}/ld_wfi_ff_chip3.xml \
    Background=yes \
    Attitude=none \
    RA=${ra} \
    Dec=${dec} \
    Simput=${simput} \
    Exposure=100.0 \
    clobber=yes
if ( $? == 0 ) then
	echo ... athenawfisim successful
	else
	echo FAILED on athenawfisim call && exit(0)
endif

$SIXTE/bin/runsixt \
    EvtFile=test_ld.evt \
    XMLFile=${xmldir}/ld_wfi_ff_large.xml \
    Background=yes \
    Attitude=none \
    RA=${ra} \
    Dec=${dec} \
    Simput=${simput} \
    Exposure=100.0 \
    GTIFile=none \
    dt=1.0 \
    chatter=3 \
    clobber=yes \
    history=true
if ( $? == 0 ) then
	echo ... runsixt on LD successful
	else
	echo FAILED on runsixt on LD call && exit(0)
endif
	
$SIXTE/bin/makespec \
    EvtFile=test_ld.evt \
    Spectrum=test_ld.pha \
    RSPPath=${xmldir} \
    clobber=yes
if ( $? == 0 ) then
	echo ... makespec on LD successful
	else
	echo FAILED on makespec on LD call && exit(0)
endif


# Test Fast Detector
$SIXTE/bin/runsixt \
    EvtFile=test_fd.evt \
    XMLFile=${xmldir}/fd_wfi_ff_df35mm.xml \
    Background=yes \
    Attitude=none \
    RA=${ra} Dec=${dec} \
    Simput=${simput} \
    Exposure=100.0 \
    clobber=yes
if ( $? == 0 ) then
	echo ... runsixt on FD successful
	else
	echo FAILED on runsixt on FD call && exit(0)
endif

$SIXTE/bin/makespec \
    EvtFile=test_fd.evt \
    Spectrum=test_fd.pha \
    RSPPath=${xmldir} \
    clobber=yes
if ( $? == 0 ) then
	echo ... makespec on FD successful
	else
	echo FAILED on makespec on FD call && exit(0)
endif
    
