#!/bin/bash

# Function to measure and print execution time of a command. Prints a warning
# if execution time exceeds given reference time.
# 
# Usage: measure_execution_time command execution_time_seconds_ref
# Example: measure_execution_time ./simulation.sh 10.5
measure_execution_time() {
  local command="$1"
  local execution_time_seconds_ref=$2

  local start_time_nanoseconds=$(date +%s%N)

  eval "$command"

  local execution_time_nanoseconds=$(( $(date +%s%N) - start_time_nanoseconds ))
  local execution_time_seconds=$(echo "scale=12; $execution_time_nanoseconds / 1000000000" | bc)

  printf "execution time: %.2fs (ref: %.2fs)\n" "$execution_time_seconds" "$execution_time_seconds_ref" 

  if (( $(echo "$execution_time_seconds > $execution_time_seconds_ref" | bc -l) )); then
    printf "Warning: execution time exceeded %.2fs\n" "$execution_time_seconds_ref"
  fi
}