/*
   *** AUTOMATICALLY GENERATED: DO NOT EDIT THIS FILE ***   

   This file is part of the RELXILL model code.

   RELXILL is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   RELXILL is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.
   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.

    Copyright 2021 Thomas Dauser, Remeis Observatory & ECAP
       
    *** AUTOMATICALLY GENERATED: DO NOT EDIT THIS FILE ***       
*/

#ifndef RELXILL_XSPEC_WRAPPER_H_
#define RELXILL_XSPEC_WRAPPER_H_



#include "ModelDefinition.h"

class XspecParamList: public ParamList {

 public:
  XspecParamList(std::string model_name, std::vector<XPar> parnames, std::vector<double> parvalues):
      ParamList(std::move(parnames), std::move(parvalues)) {
        m_name = std::move(model_name);
      };

  [[nodiscard]] std::string name() const {
    return m_name;
  }

 private:
  std::string m_name;
};


class XspecModelDatabase{

 public:
  std::string name_string(ModelName name) const{
    return model_definition.at(name).name();
  }

  ParamList param_list(ModelName name) const{
    return model_definition.at(name);
  }

  std::unordered_map<ModelName, XspecParamList> all_models() const{
    return model_definition;
  }

 private:
  const std::unordered_map<ModelName, XspecParamList> model_definition = {
  {   {ModelName::relline,
    XspecParamList("relline", 
        { XPar::linee, XPar::index1, XPar::index2, XPar::rbr, XPar::a, XPar::incl, XPar::rin, XPar::rout, XPar::z, XPar::limb}, 
	 {6.4, 3., 3., 15.0, 0.998, 30., -1., 400., 0., 0.})
   },
   {ModelName::relconv,
    XspecParamList("relconv", 
        { XPar::index1, XPar::index2, XPar::rbr, XPar::a, XPar::incl, XPar::rin, XPar::rout, XPar::limb}, 
	 {3., 3., 15.0, 0.998, 30., -1., 400., 0.})
   },
   {ModelName::relline_lp,
    XspecParamList("relline_lp", 
        { XPar::linee, XPar::h, XPar::a, XPar::incl, XPar::rin, XPar::rout, XPar::z, XPar::limb, XPar::gamma, XPar::switch_switch_returnrad}, 
	 {6.4, 6.0, 0.998, 30., -1., 400., 0., 0., 2, 1})
   },
   {ModelName::relconv_lp,
    XspecParamList("relconv_lp", 
        { XPar::h, XPar::beta, XPar::a, XPar::incl, XPar::rin, XPar::rout, XPar::limb, XPar::gamma, XPar::switch_switch_returnrad}, 
	 {6.0, 0.0, 0.998, 30., -1., 400., 0., 2, 1})
   },
   {ModelName::relxill,
    XspecParamList("relxill", 
        { XPar::index1, XPar::index2, XPar::rbr, XPar::a, XPar::incl, XPar::rin, XPar::rout, XPar::z, XPar::gamma, XPar::logxi, XPar::afe, XPar::ecut, XPar::refl_frac}, 
	 {3., 3., 15.0, 0.998, 30., -1., 400., 0., 2., 3.1, 1., 300., 3.})
   },
   {ModelName::relxilllp,
    XspecParamList("relxilllp", 
        { XPar::h, XPar::beta, XPar::a, XPar::incl, XPar::rin, XPar::rout, XPar::z, XPar::gamma, XPar::logxi, XPar::afe, XPar::ecut, XPar::refl_frac, XPar::switch_switch_returnrad, XPar::switch_switch_reflfrac_boost}, 
	 {6.0, 0.0, 0.998, 30., -1., 400., 0., 2., 3.1, 1., 300., 1.0, 1, 0})
   },
   {ModelName::xillver,
    XspecParamList("xillver", 
        { XPar::gamma, XPar::afe, XPar::ecut, XPar::logxi, XPar::z, XPar::incl, XPar::refl_frac}, 
	 {2., 1., 300., 3.1, 0., 30., -1.})
   },
   {ModelName::xillverCp,
    XspecParamList("xillverCp", 
        { XPar::gamma, XPar::afe, XPar::kte, XPar::logxi, XPar::logn, XPar::z, XPar::incl, XPar::refl_frac}, 
	 {2., 1., 60., 3.1, 15., 0., 30., -1.})
   },
   {ModelName::relxillCp,
    XspecParamList("relxillCp", 
        { XPar::incl, XPar::a, XPar::rin, XPar::rout, XPar::rbr, XPar::index1, XPar::index2, XPar::z, XPar::gamma, XPar::logxi, XPar::logn, XPar::afe, XPar::kte, XPar::refl_frac}, 
	 {30., 0.998, -1., 400., 15.0, 3., 3., 0., 2., 3.1, 15., 1., 60., 3.})
   },
   {ModelName::relxilllpCp,
    XspecParamList("relxilllpCp", 
        { XPar::incl, XPar::a, XPar::rin, XPar::rout, XPar::h, XPar::beta, XPar::gamma, XPar::logxi, XPar::logn, XPar::afe, XPar::kte, XPar::refl_frac, XPar::z, XPar::iongrad_index, XPar::switch_iongrad_type, XPar::switch_switch_returnrad, XPar::switch_switch_reflfrac_boost}, 
	 {30., 0.998, -1., 400., 6.0, 0.0, 2., 3.1, 15., 1., 60., 1, 0., 0.0, 0, 1, 0})
   },
   {ModelName::xillverNS,
    XspecParamList("xillverNS", 
        { XPar::ktbb, XPar::afe, XPar::logn, XPar::logxi, XPar::z, XPar::incl, XPar::refl_frac}, 
	 {2., 1., 15., 3.1, 0., 30., -1.})
   },
   {ModelName::relxillNS,
    XspecParamList("relxillNS", 
        { XPar::index1, XPar::index2, XPar::rbr, XPar::a, XPar::incl, XPar::rin, XPar::rout, XPar::z, XPar::ktbb, XPar::logxi, XPar::afe, XPar::logn, XPar::refl_frac}, 
	 {3., 3., 15.0, 0.998, 30., -1., 400., 0., 2., 3.1, 1., 15., 3.})
   },
   {ModelName::relline_ring,
    XspecParamList("relline_ring", 
        { XPar::linee, XPar::r_src, XPar::theta_src, XPar::a, XPar::incl, XPar::rin, XPar::rout, XPar::z, XPar::limb, XPar::gamma, XPar::switch_switch_returnrad}, 
	 {6.4, 6.0, 0.0, 0.998, 30., -1., 400., 0., 0., 2, 1})
   },
   {ModelName::relxill_ring,
    XspecParamList("relxill_ring", 
        { XPar::incl, XPar::a, XPar::rin, XPar::rout, XPar::r_src, XPar::theta_src, XPar::gamma, XPar::logxi, XPar::logn, XPar::afe, XPar::kte, XPar::refl_frac, XPar::z, XPar::iongrad_index, XPar::switch_iongrad_type, XPar::switch_switch_returnrad, XPar::switch_switch_reflfrac_boost}, 
	 {30., 0.998, -1., 400., 6.0, 0.0, 2., 3.1, 15., 1., 60., 1, 0., 0.0, 0, 1, 0})
   },
   {ModelName::relxill_ring_ecut,
    XspecParamList("relxill_ring_ecut", 
        { XPar::incl, XPar::a, XPar::rin, XPar::rout, XPar::r_src, XPar::theta_src, XPar::z, XPar::gamma, XPar::logxi, XPar::afe, XPar::ecut, XPar::refl_frac, XPar::switch_switch_returnrad, XPar::switch_switch_reflfrac_boost}, 
	 {30., 0.998, -1., 400., 6.0, 0.0, 0., 2., 3.1, 1., 300., 1.0, 1, 0})
   },
  }
 };

 };

#endif //RELXILL_XSPEC_WRAPPER_H_